<?php
require_once '../../config/config.php';
require_once '../../includes/DB.php';

if (!isset($_SESSION['client_user_id'])) {
    header('Location: login.php');
    exit;
}

$db = DB::conn();
$clientId = $_SESSION['client_id'];

// Stats
$stats = [
    'meters' => $db->prepare("SELECT COUNT(*) as c FROM meters WHERE client_id = ? AND is_active=1"),
    'customers' => $db->prepare("SELECT COUNT(*) as c FROM customers WHERE client_id = ? AND is_active=1"),
    'today_revenue' => $db->prepare("SELECT COALESCE(SUM(amount),0) as c FROM payments WHERE client_id = ? AND DATE(tx_date)=CURDATE() AND status='PROCESSED'"),
    'today_tokens' => $db->prepare("SELECT COUNT(*) as c FROM tokens WHERE client_id = ? AND DATE(created_at)=CURDATE()"),
    'pending_vends' => $db->prepare("SELECT COUNT(*) as c FROM vending_requests vr JOIN payments p ON vr.payment_id = p.id WHERE p.client_id = ? AND vr.status='FAILED' AND vr.next_retry_at IS NOT NULL")
];

foreach ($stats as $key => $stmt) {
    $stmt->execute([$clientId]);
    $stats[$key] = $stmt->fetch()['c'];
}

// Recent tokens
$tokens = $db->prepare("
    SELECT t.*, m.meter_id, cu.first_name, cu.last_name, cu.phone
    FROM tokens t
    JOIN meters m ON t.meter_id = m.id
    JOIN customers cu ON t.customer_id = cu.id
    WHERE t.client_id = ?
    ORDER BY t.created_at DESC
    LIMIT 10
");
$tokens->execute([$clientId]);
$tokens = $tokens->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Client Dashboard</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <div class="flex">
        <?php include 'sidebar.php'; ?>
        
        <div class="main-content w-full">
            <div class="top-bar">
                <div>
                    <h1 class="text-blue">Dashboard</h1>
                    <small class="text-gray"><?= htmlspecialchars($_SESSION['company_name']) ?></small>
                </div>
                <div class="flex items-center gap-4">
                    <span><?= htmlspecialchars($_SESSION['client_name']) ?></span>
                    <a href="logout.php" class="btn btn-sm" style="background:#dc3545;color:white">Logout</a>
                    <button class="hamburger" onclick="toggleSidebar()"><i class="fas fa-bars"></i></button>
                </div>
            </div>
            
            <div class="content">
                <div class="grid grid-cols-3 gap-4 mb-4">
                    <div class="stat-card">
                        <h3>Active Meters</h3>
                        <div class="value"><?= $stats['meters'] ?></div>
                    </div>
                    <div class="stat-card orange">
                        <h3>Customers</h3>
                        <div class="value"><?= $stats['customers'] ?></div>
                    </div>
                    <div class="stat-card">
                        <h3>Today Revenue</h3>
                        <div class="value">KES <?= number_format($stats['today_revenue'], 2) ?></div>
                    </div>
                </div>
                
                <div class="grid grid-cols-2 gap-4 mb-4">
                    <div class="stat-card orange">
                        <h3>Today Tokens</h3>
                        <div class="value"><?= $stats['today_tokens'] ?></div>
                    </div>
                    <div class="stat-card" style="border-left-color:<?= $stats['pending_vends'] > 0 ? '#dc3545' : '#28a745' ?>">
                        <h3>Pending Vends</h3>
                        <div class="value"><?= $stats['pending_vends'] ?></div>
                        <?php if ($stats['pending_vends'] > 0): ?>
                            <small style="color:#dc3545">Will retry automatically</small>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="table-container">
                    <div class="table-header">
                        <h2>Recent Tokens</h2>
                        <a href="tokens.php" class="btn btn-sm btn-primary">View All</a>
                    </div>
                    <table>
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Meter</th>
                                <th>Customer</th>
                                <th>Amount</th>
                                <th>Units</th>
                                <th>Token</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($tokens as $t): ?>
                                <tr>
                                    <td><?= date('Y-m-d H:i', strtotime($t['created_at'])) ?></td>
                                    <td><?= htmlspecialchars($t['meter_id']) ?></td>
                                    <td>
                                        <?= htmlspecialchars($t['first_name'].' '.$t['last_name']) ?><br>
                                        <small><?= htmlspecialchars($t['phone']) ?></small>
                                    </td>
                                    <td>KES <?= number_format($t['amount'], 2) ?></td>
                                    <td><?= number_format($t['units'], 2) ?></td>
                                    <td><code style="font-size:0.75rem"><?= htmlspecialchars($t['token_value']) ?></code></td>
                                    <td>
                                        <?php
                                        $badgeClass = [
                                            'DELIVERED' => 'badge-success',
                                            'CREATED' => 'badge-warning',
                                            'FAILED' => 'badge-danger'
                                        ][$t['status']] ?? 'badge-info';
                                        ?>
                                        <span class="badge <?= $badgeClass ?>"><?= $t['status'] ?></span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <script>
function toggleSidebar() {
    document.querySelector('.sidebar').classList.toggle('active');
}
</script>
</body>
</html>