<?php
class StronpowerService {
    private $timeout;
    
    public function __construct($timeout = STRON_TIMEOUT) {
        $this->timeout = $timeout;
    }
    
    private function post($url, $payload) {
        try {
            $ch = curl_init($url);
            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => json_encode($payload),
                CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
                CURLOPT_TIMEOUT => $this->timeout,
                CURLOPT_SSL_VERIFYPEER => false
            ]);
            
            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $error = curl_error($ch);
            curl_close($ch);
            
            if ($error) {
                return [false, null, $error];
            }
            
            if ($httpCode !== 200) {
                return [false, null, "HTTP $httpCode"];
            }
            
            $data = json_decode($response, true);
            if (json_last_error() !== JSON_ERROR_NONE) {
                return [false, null, "Invalid JSON"];
            }
            
            return [true, $data, null];
        } catch (Exception $e) {
            return [false, null, $e->getMessage()];
        }
    }
    
    public function queryMeterInfo($credentials, $meterId) {
        $url = STRON_BASE_URL . '/QueryMeterInfo';
        $payload = [
            'CompanyName' => $credentials['company_name'],
            'UserName' => $credentials['username'],
            'PassWord' => $credentials['password'],
            'MeterId' => $meterId
        ];
        return $this->post($url, $payload);
    }
    
    public function queryMeterCredit($credentials, $meterId) {
        $url = STRON_BASE_URL . '/QueryMeterCredit';
        $payload = [
            'CompanyName' => $credentials['company_name'],
            'UserName' => $credentials['username'],
            'PassWord' => $credentials['password'],
            'MeterId' => $meterId
        ];
        return $this->post($url, $payload);
    }
    
    public function vendingMeter($credentials, $meterId, $amount, $isVendByUnit = false, $customerId = null) {
        $url = STRON_BASE_URL . '/VendingMeter';
        $payload = [
            'CompanyName' => $credentials['company_name'],
            'UserName' => $credentials['username'],
            'PassWord' => $credentials['password'],
            'MeterID' => $meterId,
            'is_vend_by_unit' => $isVendByUnit ? 'true' : 'false',
            'Amount' => (string)$amount
        ];
        
        if ($customerId) {
            $payload['CustomerId'] = $customerId;
        }
        
        list($ok, $data, $error) = $this->post($url, $payload);
        
        if (!$ok) {
            return [false, null, $error];
        }
        
        if (empty($data)) {
            return [false, $data, "Empty response"];
        }
        
        // Extract token
        $obj = is_array($data) && isset($data[0]) ? $data[0] : $data;
        $token = null;
        $units = null;
        
        if (is_array($obj)) {
            $token = $obj['Token'] ?? $obj['token'] ?? $obj['TokenNo'] ?? $obj['TokenNo1'] ?? null;
            $units = $obj['Total_unit'] ?? $obj['total_unit'] ?? $obj['Units'] ?? $obj['units'] ?? null;
        } else {
            $token = (string)$obj;
        }
        
        if (!$token) {
            return [false, $data, "No token in response"];
        }
        
        return [true, ['token' => $token, 'units' => $units, 'raw' => $data], null];
    }
    
    public function clearCredit($credentials, $meterId, $customerId) {
        $url = STRON_BASE_URL . '/ClearCredit';
        $payload = [
            'CompanyName' => $credentials['company_name'],
            'UserName' => $credentials['username'],
            'PassWord' => $credentials['password'],
            'CustomerId' => $customerId,
            'METER_ID' => $meterId
        ];
        
        list($ok, $data, $error) = $this->post($url, $payload);
        
        if (!$ok) {
            return [false, null, $error];
        }
        
        $token = null;
        if (is_array($data) && !empty($data)) {
            $first = $data[0];
            $token = is_array($first) ? ($first['Token'] ?? null) : (string)$first;
        }
        
        return [true, $token, null];
    }
    
    public function clearTamper($credentials, $meterId, $customerId) {
        $url = STRON_BASE_URL . '/ClearTamper';
        $payload = [
            'CompanyName' => $credentials['company_name'],
            'UserName' => $credentials['username'],
            'PassWord' => $credentials['password'],
            'CustomerId' => $customerId,
            'METER_ID' => $meterId
        ];
        
        list($ok, $data, $error) = $this->post($url, $payload);
        
        if (!$ok) {
            return [false, null, $error];
        }
        
        $token = null;
        if (is_array($data) && !empty($data)) {
            $first = $data[0];
            $token = is_array($first) ? ($first['Token'] ?? null) : (string)$first;
        }
        
        return [true, $token, null];
    }
}
