<?php
class SMSService {
    public static function normalizePhone($phone) {
        if (empty($phone)) return '';
        
        $phone = preg_replace('/[^\d+]/', '', $phone);
        
        if (substr($phone, 0, 1) === '0') {
            return '+254' . substr($phone, 1);
        } elseif (substr($phone, 0, 3) === '254') {
            return '+' . $phone;
        } elseif (substr($phone, 0, 4) === '+254') {
            return $phone;
        }
        
        return $phone;
    }
    
    public function send($to, $message) {
        $to = self::normalizePhone($to);
        
        if (empty($to)) {
            return [false, 'Invalid phone'];
        }
        
        try {
            $url = 'https://api.africastalking.com/version1/messaging';
            
            $data = [
                'username' => AT_USERNAME,
                'to' => $to,
                'message' => $message
            ];
            
            if (!empty(AT_SENDER)) {
                $data['from'] = AT_SENDER;
            }
            
            $ch = curl_init($url);
            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => http_build_query($data),
                CURLOPT_HTTPHEADER => [
                    'apiKey: ' . AT_API_KEY,
                    'Content-Type: application/x-www-form-urlencoded',
                    'Accept: application/json'
                ],
                CURLOPT_TIMEOUT => 30
            ]);
            
            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $error = curl_error($ch);
            curl_close($ch);
            
            if ($error) {
                return [false, $error];
            }
            
            $result = json_decode($response, true);
            
            if ($httpCode == 200 || $httpCode == 201) {
                if (isset($result['SMSMessageData']['Recipients'])) {
                    $recipients = $result['SMSMessageData']['Recipients'];
                    if (!is_array($recipients)) {
                        $recipients = [$recipients];
                    }
                    
                    foreach ($recipients as $r) {
                        if (is_array($r)) {
                            $status = $r['status'] ?? $r['Status'] ?? '';
                            if (strtolower($status) === 'success') {
                                return [true, $response];
                            }
                        }
                    }
                }
            }
            
            return [false, $response];
            
        } catch (Exception $e) {
            return [false, $e->getMessage()];
        }
    }
    
    public function sendToken($phone, $meterId, $token, $amount, $units) {
        $message = "Your water token for meter $meterId is: $token. " .
                  "Amount: KES " . number_format($amount, 2) . ". " .
                  "Units: " . number_format($units, 2);
        
        return $this->send($phone, $message);
    }
}
