<?php
class DB {
    private static $pdo = null;
    
    public static function conn() {
        if (self::$pdo === null) {
            try {
                self::$pdo = new PDO(
                    "mysql:host=".DB_HOST.";dbname=".DB_NAME.";charset=utf8mb4",
                    DB_USER,
                    DB_PASS,
                    [
                        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                        PDO::ATTR_EMULATE_PREPARES => false
                    ]
                );
            } catch(PDOException $e) {
                die("DB Error: " . $e->getMessage());
            }
        }
        return self::$pdo;
    }
}
