# Water Vending System

Multi-client water vending with Stronpower API, M-Pesa C2B, and Africa's Talking SMS.

## Features
✅ Multi-client management
✅ M-Pesa C2B automatic payment processing
✅ Stronpower API integration (vending, clear credit, clear tamper)
✅ Africa's Talking SMS (+254 normalization)
✅ Automatic retry logic (exponential backoff)
✅ One meter = One customer validation
✅ Manual token generation
✅ Comprehensive analytics

## Installation

### 1. Upload to cPanel
Upload to `/public_html/water-vending/` (or any folder)

### 2. Database Setup
- Import `database.sql` via phpMyAdmin
- Default admin: username=`admin`, password=`admin123`

### 3. Configuration
Edit `config/config.php`:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'water_vending');
define('DB_USER', 'your_user');
define('DB_PASS', 'your_pass');
define('BASE_URL', 'https://yourdomain.com/water-vending/public');
define('AT_USERNAME', 'your_at_username');
define('AT_API_KEY', 'your_at_api_key');
```

### 4. Permissions
```bash
chmod 777 logs/
chmod 777 temp/
```

### 5. Cron Job
Add to cPanel cron (every 5 minutes):
```
*/5 * * * * php /path/to/cron/retry_vendings.php
```

### 6. M-Pesa Setup
Per client, configure in Daraja:
- Validation: `https://yourdomain.com/water-vending/public/api/mpesa/validation.php`
- Confirmation: `https://yourdomain.com/water-vending/public/api/mpesa/confirmation.php`

## Access
- Admin: `/public/admin/` (user: admin, pass: admin123)
- Client: `/public/client/` (create via admin)

## Color Scheme
- Blue: #1b405f
- Gray: #545454
- Orange: #f78510
- White: #ffffff

## API Flow
1. Customer pays via M-Pesa (Paybill + Meter ID)
2. M-Pesa → Validation → Accept
3. M-Pesa → Confirmation → Process:
   - Find client by paybill
   - Find meter by account number
   - Find customer by meter assignment
   - Call Stronpower API
   - Generate token
   - Send SMS (+254 normalized)
   - If fails → Schedule retry

## Tech Stack
- PHP 7.4+
- MySQL 5.7+
- Stronpower API
- M-Pesa Daraja C2B
- Africa's Talking SMS
- Tailwind-style CSS

## Support
Check logs in `/logs/` directory
